% DECOMPOSITION OF THE EXPECTED NONEMPLOYMENT DURATION
% INTO HETEROGENEITY AND DURATION DEPENDENCE

function out = fct_decomposition_observables(GG,observables,output_files_write)
%clear all
%close all

% LOAD PARAMETERS 
%--------------------------------------------------------------------------
% ESTIMATED TYPES
% load estimates_RP.mat

% DATA
%COL 1: pid_new
%COL 2: duration1
%COL 3: duration2
%COL 4: age1
%COL 5: age2
%COL 6: recall1
%COL 7: recall2
%COL 8: NACE101
%COL 9: NACE102
%COL 10: region1
%COL 11: region2
%COL 12: precall_OLS1
%COL 13: precall_OLS2
%COL 14: precall_LOG1
%COL 15: precall_LOG2
%COL 16: precall_PRO1
%COL 17: precall_PRO2
%COL 18: A1
%COL 19: B1
%COL 20: B3a
%COL 21: B4
%COL 22: educ
%COL 23: male

    mm_mat = fieldnames(GG);
    for i = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(i)) '= GG.(cell2mat(mm_mat(i)));']);
    end


%observables = csvread('IG_raw_0_105_Dec2021_with_observables.csv',1,0);    
%observables = csvread('IG_raw_0_105_RP_with_observables.csv',1,0);    
A1 = sum(observables(:,18)==1);
B1 = sum(observables(:,19)==1);
B34 = sum(observables(:,20)==1) + sum(observables(:,21)==1);
Npeople = size(observables,1);

% compute probability of including B34 workers
% A1/(A1+B1+B34)
% A1/(A1+B1)
 p34 = (A1/GG.GBARP2.p1_est -A1-B1)/B34 ;
% A1/(A1+B1+B34*p34)

% construct type posterior for each person
% GBAR, G
Gnames = {'GBAR', 'GUSHORT', 'GBARW', 'GUSHORTW',...
'GBARP2', 'GUSHORTP2', 'GBARP2W', 'GUSHORTP2W'};

%output_files_write  = 1;
out = 1;

for obs_char_loop  = 1:6
    
    OBS_GENDER = 0;
    OBS_RECALL = 0;
    OBS_RECALL_1090 = 0;
    OBS_EDUC   = 0;
    OBS_AGE    = 0;
    OBS_NACE   = 0;


    if obs_char_loop  == 1
        OBS_GENDER = 1;
    end
    if obs_char_loop  == 2
        OBS_RECALL = 1;
    end
    if obs_char_loop  == 3
        OBS_RECALL_1090 = 1;
    end
    if obs_char_loop  == 4
        OBS_EDUC   = 1;
    end
    if obs_char_loop  == 5
        OBS_AGE    = 1;
    end
    if obs_char_loop  == 6
        OBS_NACE   = 1;
    end

    if (OBS_GENDER + OBS_RECALL + OBS_RECALL_1090 + OBS_EDUC + OBS_AGE+OBS_NACE)~=1
        disp('One and only one choice can be selected')
        return
    end

% PREPARE DATA; SELECT WORKERS FROM DIFFERENT CATEGORIES
N       = size(observables,1);
sel_A1a = (observables(:,18)==1) & (observables(:,2) <=104 ) & (observables(:,3) <= 104);
sel_A1b = (observables(:,18)==1) & (sel_A1a == 0 ) ;
sel_B1  = observables(:,19)==1;
sel_B34 = (observables(:,20)==1) | (observables(:,21)==1);

t1vec        = observables(sel_A1a,2)+0.5;
t2vec        = observables(sel_A1a,3)+0.5;    
tvec         = observables(sel_A1b,2)+0.5;

% CHOOSE OBSERVABLE CHARACTERISTIC
%--------------------------------------------------------------------------
% GENDER AS A CHARACTERISTIC
if OBS_GENDER ==1
    val = [0,1];    % value of the selection criterium
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 23;
    clear selobs share_emp
    
    for i = 1:GR
        selobs(:,i) = (observables(:,index_obs) == val(i)); 
        shareT0(i)  = sum(selobs(:,i))/N;   
        empT0(i)    = sum(selobs(:,i));   
        times       = observables(selobs(:,i),2);
        counts      = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end
    
%--------------------------------------------------------------------------    
% RECALL
if OBS_RECALL ==1
    val = [0,1,2];    % value of the selection criterium
    probs = [0,0.25,0.75,1.05];
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 16;
     clear selobs share_emp
    
    for i = 1:GR
        selobs(:,i) = (observables(:,index_obs) >= probs(i)) & (observables(:,index_obs) < probs(i+1)); 
        shareT0(i) = sum(selobs(:,i))/N;   
        empT0(i) = sum(selobs(:,i));   
        times = observables(selobs(:,i),2);
        counts = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end

%--------------------------------------------------------------------------    
% RECALL -- 10/90 split of the data
if OBS_RECALL_1090 ==1
    val = [0,1,2];    % value of the selection criterium
    probs = [0,0.1,0.80,1.05];
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 16;
     clear selobs  share_emp
    
    for i = 1:GR
        selobs(:,i) = (observables(:,index_obs) >= probs(i)) & (observables(:,index_obs) < probs(i+1)); 
        shareT0(i) = sum(selobs(:,i))/N;   
        empT0(i) = sum(selobs(:,i));   
        times = observables(selobs(:,i),2);
        counts = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end

%--------------------------------------------------------------------------
% EDUCATION
if OBS_EDUC ==1
    val = [0,1,2,3,4,5];  % value of the selection criterium       
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 22;
     clear selobs share_emp
    
    for i = 1:GR
        selobs(:,i) = observables(:,index_obs) == val(i);
        shareT0(i) = sum(selobs(:,i))/N;   
        empT0(i) = sum(selobs(:,i));   
        times = observables(selobs(:,i),2);
        counts = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end

%--------------------------------------------------------------------------
% AGE
if OBS_AGE ==1
    val = [0,1,2,3];  % value of the selection criterium       
    probs = [25,35,45,55,100];
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 4;
     clear selobs share_emp

    for i = 1:GR
        selobs(:,i) = (observables(:,index_obs) > probs(i)) & (observables(:,index_obs) <= probs(i+1)); 
        shareT0(i) = sum(selobs(:,i))/N;   
        empT0(i) = sum(selobs(:,i));   
        times = observables(selobs(:,i),2);
        counts = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end
    
%--------------------------------------------------------------------------
% INDUSTRY
if OBS_NACE ==1
    val = [1:1:9, 0];  % value of the selection criterium           
    GR  = length(val);           % number of groups
    shareT0  = zeros(1,GR);      % initial share of each group
    index_obs = 8;
     clear selobs  share_emp

    for i = 1:GR
       selobs(:,i) = observables(:,index_obs) == val(i);
        shareT0(i) = sum(selobs(:,i))/N;   
        empT0(i) = sum(selobs(:,i));   
        times = observables(selobs(:,i),2);
        counts = hist(times,261);
        share_emp(i,:) = counts; 
    end
    share_emp = share_emp./repmat(sum(share_emp,1),GR,1);
end

%--------------------------------------------------------------------------      
    
% PREPARE MATRICES
    T = length(GBARdecomp.tgrid);
    DECbounds.HR_agg_min_group         = zeros(T,GR);
    DECbounds.HR_struc_multi_min_group = zeros(T,GR);
    DECbounds.HR_heter_multi_min_group = zeros(T,GR);
    DECbounds.HR_B_multi_min           = zeros(T,1);

    DECbounds.HR_agg_max_group         = zeros(T,GR);
    DECbounds.HR_struc_multi_max_group = zeros(T,GR);
    DECbounds.HR_heter_multi_max_group = zeros(T,GR);
    DECbounds.HR_B_multi_max           = zeros(T,1);

% MAIN CALCULATION
kk = 0; 
for g = 1:length(Gnames)
    kk = kk+1;
    G     = eval(cell2mat(Gnames(g)));
    G.K   = length(G.g_vec);
    G.type_posterior = zeros(N,G.K);
    
    for k = 1:G.K   
        % 2 complete spells shorter than \barT
        G.f1f2_vec(:,k) = fct_pdf_f(t1vec,G.mu_vec(k),G.sigma_vec(k)).* fct_pdf_f(t2vec,G.mu_vec(k),G.sigma_vec(k))*G.g_vec(k);            
        % workers with second spell longer than \barT
        G.f1f2_v2_vec(:,k) = fct_pdf_f(tvec,G.mu_vec(k),G.sigma_vec(k))*(1-fct_CDF_F_capped(104.5,G.mu_vec(k),G.sigma_vec(k)))*G.g_vec(k);            
        % workers with first spell longer than \bar T
        G.F1_T_vec(k) = (1-fct_CDF_F_capped(104.5,G.mu_vec(k),G.sigma_vec(k)))*G.g_vec(k);            
        % workers with first spell longer than 2\bar T
        G.F1_2T_vec(k) = (1-fct_CDF_F_capped(2*104.5,G.mu_vec(k),G.sigma_vec(k)))*G.g_vec(k);    
    end
    
    % 2 complete spells shorter than \barT
    G.f1f2_sum = sum(G.f1f2_vec,2);
    G.type_posterior(sel_A1a,:) = G.f1f2_vec./repmat(G.f1f2_sum,1,G.K);
    
    % workers with second spell longer than \barT
    G.f1f2_v2_sum = sum(G.f1f2_v2_vec,2);
    G.type_posterior(sel_A1b,:) = G.f1f2_v2_vec./repmat(G.f1f2_v2_sum,1,G.K);
    
    % workers with first spell longer than \bar T
    G.F1_T = G.F1_T_vec/sum(G.F1_T_vec);
    G.type_posterior(sel_B1,:) = repmat(G.F1_T,sum(sel_B1),1);
    
    % workers with first spell longer than 2\bar T
    G.F1_2T = G.F1_2T_vec/sum(G.F1_2T_vec);
    G.type_posterior(sel_B34,:) = repmat(G.F1_2T,sum(sel_B34),1);
           
% g distribution for each group
    g_vec_group = zeros(G.K,GR); 
    weights = ones(N,1);    
    if g>=5
    weights(sel_B34) = p34;
    end
    for i = 1:GR       
        g_vec_group(:,i) = sum(weights(selobs(:,i)).*G.type_posterior(selobs(:,i),:))'/sum(weights(selobs(:,i)));        
        g_vec_group(:,i) = g_vec_group(:,i)/sum(g_vec_group(:,i));        
    end

    DECinput.g_vec_group = g_vec_group;
    DECinput.mu_vec = G.mu_vec;
    DECinput.sigma_vec = G.sigma_vec;
    DECinput.g_vec = G.g_vec;
    DECinput.shareT0 = shareT0;
    DEC = fct_decomposition_increments_observables(DECinput);

    if kk==1
        DECbounds.HR_agg_min_group = DEC.HR_agg_group;
        DECbounds.HR_struc_multi_min_group = DEC.HR_struc_multi_group;
        DECbounds.HR_heter_multi_min_group = DEC.HR_heter_multi_group;
        DECbounds.HR_B_multi_min = DEC.HR_B_multi(:);

        DECbounds.HR_agg_max_group = DEC.HR_agg_group;
        DECbounds.HR_struc_multi_max_group = DEC.HR_struc_multi_group;
        DECbounds.HR_heter_multi_max_group = DEC.HR_heter_multi_group;
        DECbounds.HR_B_multi_max           = DEC.HR_B_multi;
    else
        for i = 1:GR
            DECbounds.HR_agg_min_group(:,i) = min(DEC.HR_agg_group(:,i),DECbounds.HR_agg_min_group(:,i));        
            DECbounds.HR_struc_multi_min_group(:,i) = min(DEC.HR_struc_multi_group(:,i),DECbounds.HR_struc_multi_min_group(:,i));
            DECbounds.HR_heter_multi_min_group(:,i) = min(DEC.HR_heter_multi_group(:,i),DECbounds.HR_heter_multi_min_group(:,i));
            DECbounds.HR_B_multi_min(:) = min(DEC.HR_B_multi(:),DECbounds.HR_B_multi_min(:));

            DECbounds.HR_agg_max_group(:,i)         = max(DEC.HR_agg_group(:,i),DECbounds.HR_agg_max_group(:,i));        
            DECbounds.HR_struc_multi_max_group(:,i) = max(DEC.HR_struc_multi_group(:,i),DECbounds.HR_struc_multi_max_group(:,i));
            DECbounds.HR_heter_multi_max_group(:,i) = max(DEC.HR_heter_multi_group(:,i),DECbounds.HR_heter_multi_max_group(:,i));
            DECbounds.HR_B_multi_max(:)             = max(DEC.HR_B_multi(:),DECbounds.HR_B_multi_max(:));        
        end
    end

    DECbounds.HR_agg_mean_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_mean_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_mean_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;
    DECbounds.HR_B_multi_mean = (DECbounds.HR_B_multi_min + DECbounds.HR_B_multi_max)/2;
end    

    if obs_char_loop  == 1
        DECinput_gnd  = DECinput;
        DECbounds_gnd = DECbounds;
    end
    if obs_char_loop  == 2
        DECinput_rcl  = DECinput;
        DECbounds_rcl = DECbounds;
    end
    if obs_char_loop  == 3
        DECinput_rcl91  = DECinput;
        DECbounds_rcl91 = DECbounds;
    end
    if obs_char_loop  == 4        
        DECinput_educ  = DECinput;
        DECbounds_educ = DECbounds;
    end
    if obs_char_loop  == 5
        DECinput_age  = DECinput;
        DECbounds_age = DECbounds;
    end
    if obs_char_loop  == 6
        DECinput_nace  = DECinput;
        DECbounds_nace = DECbounds;
    end 


    % PRODUCE OUTPUT FILES
    DECbounds.HR_agg_min_group = round(DECbounds.HR_agg_min_group,5);
    DECbounds.HR_agg_max_group = round(DECbounds.HR_agg_max_group,5);
    DECbounds.HR_struc_multi_min_group = round(DECbounds.HR_struc_multi_min_group,5);
    DECbounds.HR_struc_multi_max_group = round(DECbounds.HR_struc_multi_max_group,5);
    DECbounds.HR_heter_multi_min_group = round(DECbounds.HR_heter_multi_min_group,5);
    DECbounds.HR_B_multi_min = round(DECbounds.HR_B_multi_min,5);

if (output_files_write ==1) && (OBS_GENDER == 1)

    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    % average
    HR_agg_g1 = (HR_agg_min_g1   + HR_agg_min_g1)/2;
    HR_struc_g1 = (HR_struc_min_g1 + HR_struc_max_g1)/2;
    HR_heter_g1 = (HR_heter_min_g1 + HR_heter_max_g1)/2;

    HR_agg_g2 = (HR_agg_min_g2   + HR_agg_max_g2 )/2;
    HR_struc_g2 = (HR_struc_min_g2 + HR_struc_max_g2 )/2;
    HR_heter_g2 = (HR_heter_min_g2 + HR_heter_max_g2 )/2;
    
    HR_between = (HR_between_min + HR_between_max )/2;
    if (output_files_write ==1) 
    tab = table(duration,HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1, HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_between_min,HR_between_max,...
        HR_agg_g1,HR_struc_g1,HR_heter_g1,...
        HR_agg_g2,HR_struc_g2,HR_heter_g2,...
        HR_between);        
    writetable(tab,'HR_decomposition_obs_gender_RP.txt','Delimiter',' ');        
    end
end

if (output_files_write ==1) && (OBS_RECALL == 1)
    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);

    HR_agg_min_g3 = DECbounds.HR_agg_min_group(:,3);
    HR_agg_max_g3 = DECbounds.HR_agg_max_group(:,3);
    HR_struc_min_g3 = DECbounds.HR_struc_multi_min_group(:,3);
    HR_struc_max_g3 = DECbounds.HR_struc_multi_max_group(:,3);
    HR_heter_min_g3 = DECbounds.HR_heter_multi_min_group(:,3);
    HR_heter_max_g3 = DECbounds.HR_heter_multi_max_group(:,3);
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    DECbounds.HR_agg_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;

    HR_agg_g1   = DECbounds.HR_agg_group(:,1);    
    HR_struc_g1 = DECbounds.HR_struc_multi_group(:,1);    
    HR_heter_g1 = DECbounds.HR_heter_multi_group(:,1);
    
    HR_agg_g2   = DECbounds.HR_agg_group(:,2);    
    HR_struc_g2 = DECbounds.HR_struc_multi_group(:,2);    
    HR_heter_g2 = DECbounds.HR_heter_multi_group(:,2);

    HR_agg_g3   = DECbounds.HR_agg_group(:,3);    
    HR_struc_g3 = DECbounds.HR_struc_multi_group(:,3);    
    HR_heter_g3 = DECbounds.HR_heter_multi_group(:,3);
    
    HR_between = (HR_between_min+HR_between_max)/2;
                
    tab = table(duration,...
        HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1,...
        HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_agg_min_g3, HR_agg_max_g3, ...
        HR_struc_min_g3, HR_struc_max_g3, HR_heter_min_g3,HR_heter_max_g3,...
        HR_between_min,HR_between_max,...
        HR_agg_g1, HR_struc_g1, HR_heter_g1,...
        HR_agg_g2, HR_struc_g2, HR_heter_g2,...
        HR_agg_g3, HR_struc_g3, HR_heter_g3,HR_between);
    writetable(tab,'HR_decomposition_obs_recall_RP.txt','Delimiter',' ');       
end

if (output_files_write ==1) && (OBS_RECALL_1090 == 1)
    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);

    HR_agg_min_g3 = DECbounds.HR_agg_min_group(:,3);
    HR_agg_max_g3 = DECbounds.HR_agg_max_group(:,3);
    HR_struc_min_g3 = DECbounds.HR_struc_multi_min_group(:,3);
    HR_struc_max_g3 = DECbounds.HR_struc_multi_max_group(:,3);
    HR_heter_min_g3 = DECbounds.HR_heter_multi_min_group(:,3);
    HR_heter_max_g3 = DECbounds.HR_heter_multi_max_group(:,3);
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    DECbounds.HR_agg_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;

    HR_agg_g1   = DECbounds.HR_agg_group(:,1);    
    HR_struc_g1 = DECbounds.HR_struc_multi_group(:,1);    
    HR_heter_g1 = DECbounds.HR_heter_multi_group(:,1);
    
    HR_agg_g2   = DECbounds.HR_agg_group(:,2);    
    HR_struc_g2 = DECbounds.HR_struc_multi_group(:,2);    
    HR_heter_g2 = DECbounds.HR_heter_multi_group(:,2);

    HR_agg_g3   = DECbounds.HR_agg_group(:,3);    
    HR_struc_g3 = DECbounds.HR_struc_multi_group(:,3);    
    HR_heter_g3 = DECbounds.HR_heter_multi_group(:,3);
    
    HR_between = (HR_between_min+HR_between_max)/2;
                
    tab = table(duration,...
        HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1,...
        HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_agg_min_g3, HR_agg_max_g3, ...
        HR_struc_min_g3, HR_struc_max_g3, HR_heter_min_g3,HR_heter_max_g3,...
        HR_between_min,HR_between_max,...
        HR_agg_g1, HR_struc_g1, HR_heter_g1,...
        HR_agg_g2, HR_struc_g2, HR_heter_g2,...
        HR_agg_g3, HR_struc_g3, HR_heter_g3,HR_between);
    writetable(tab,'HR_decomposition_obs_recall_1090_RP.txt','Delimiter',' ');       
end

if (output_files_write ==1) && (OBS_EDUC == 1)
    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);

    HR_agg_min_g3 = DECbounds.HR_agg_min_group(:,3);
    HR_agg_max_g3 = DECbounds.HR_agg_max_group(:,3);
    HR_struc_min_g3 = DECbounds.HR_struc_multi_min_group(:,3);
    HR_struc_max_g3 = DECbounds.HR_struc_multi_max_group(:,3);
    HR_heter_min_g3 = DECbounds.HR_heter_multi_min_group(:,3);
    HR_heter_max_g3 = DECbounds.HR_heter_multi_max_group(:,3);
    
    HR_agg_min_g4 = DECbounds.HR_agg_min_group(:,4);
    HR_agg_max_g4 = DECbounds.HR_agg_max_group(:,4);
    HR_struc_min_g4 = DECbounds.HR_struc_multi_min_group(:,4);
    HR_struc_max_g4 = DECbounds.HR_struc_multi_max_group(:,4);
    HR_heter_min_g4 = DECbounds.HR_heter_multi_min_group(:,4);
    HR_heter_max_g4 = DECbounds.HR_heter_multi_max_group(:,4);
    
    HR_agg_min_g5 = DECbounds.HR_agg_min_group(:,5);
    HR_agg_max_g5 = DECbounds.HR_agg_max_group(:,5);
    HR_struc_min_g5 = DECbounds.HR_struc_multi_min_group(:,5);
    HR_struc_max_g5 = DECbounds.HR_struc_multi_max_group(:,5);
    HR_heter_min_g5 = DECbounds.HR_heter_multi_min_group(:,5);
    HR_heter_max_g5 = DECbounds.HR_heter_multi_max_group(:,5);
    
    HR_agg_min_g6 = DECbounds.HR_agg_min_group(:,6);
    HR_agg_max_g6 = DECbounds.HR_agg_max_group(:,6);
    HR_struc_min_g6 = DECbounds.HR_struc_multi_min_group(:,6);
    HR_struc_max_g6 = DECbounds.HR_struc_multi_max_group(:,6);
    HR_heter_min_g6 = DECbounds.HR_heter_multi_min_group(:,6);
    HR_heter_max_g6 = DECbounds.HR_heter_multi_max_group(:,6);
    
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    DECbounds.HR_agg_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;

    HR_agg_g1   = DECbounds.HR_agg_group(:,1);    
    HR_struc_g1 = DECbounds.HR_struc_multi_group(:,1);    
    HR_heter_g1 = DECbounds.HR_heter_multi_group(:,1);
    
    HR_agg_g2   = DECbounds.HR_agg_group(:,2);    
    HR_struc_g2 = DECbounds.HR_struc_multi_group(:,2);    
    HR_heter_g2 = DECbounds.HR_heter_multi_group(:,2);

    HR_agg_g3   = DECbounds.HR_agg_group(:,3);    
    HR_struc_g3 = DECbounds.HR_struc_multi_group(:,3);    
    HR_heter_g3 = DECbounds.HR_heter_multi_group(:,3);
    
    HR_agg_g4   = DECbounds.HR_agg_group(:,4);    
    HR_struc_g4 = DECbounds.HR_struc_multi_group(:,4);    
    HR_heter_g4 = DECbounds.HR_heter_multi_group(:,4);
    
    HR_agg_g5   = DECbounds.HR_agg_group(:,5);    
    HR_struc_g5 = DECbounds.HR_struc_multi_group(:,5);    
    HR_heter_g5 = DECbounds.HR_heter_multi_group(:,5);
    
    HR_agg_g6   = DECbounds.HR_agg_group(:,6);    
    HR_struc_g6 = DECbounds.HR_struc_multi_group(:,6);    
    HR_heter_g6 = DECbounds.HR_heter_multi_group(:,6);
        
    HR_between = (HR_between_min+HR_between_max)/2;
                
    tab = table(duration,...
        HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1,...
        HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_agg_min_g3, HR_agg_max_g3, ...
        HR_struc_min_g3, HR_struc_max_g3, HR_heter_min_g3,HR_heter_max_g3,...
        HR_agg_min_g4, HR_agg_max_g4, ...
        HR_struc_min_g4, HR_struc_max_g4, HR_heter_min_g4,HR_heter_max_g4,...
        HR_agg_min_g5, HR_agg_max_g5, ...
        HR_struc_min_g5, HR_struc_max_g5, HR_heter_min_g5,HR_heter_max_g5,...
        HR_agg_min_g6, HR_agg_max_g6, ...
        HR_struc_min_g6, HR_struc_max_g6, HR_heter_min_g6,HR_heter_max_g6,...        
        HR_between_min,HR_between_max,...
        HR_agg_g1, HR_struc_g1, HR_heter_g1,...
        HR_agg_g2, HR_struc_g2, HR_heter_g2,...
        HR_agg_g3, HR_struc_g3, HR_heter_g3,...
        HR_agg_g4, HR_struc_g4, HR_heter_g4,...
        HR_agg_g5, HR_struc_g5, HR_heter_g5,...
        HR_agg_g6, HR_struc_g6, HR_heter_g6,...
        HR_between);
    writetable(tab,'HR_decomposition_obs_educ_RP.txt','Delimiter',' ');       
end

if (output_files_write ==1) && (OBS_AGE == 1)
    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);

    HR_agg_min_g3 = DECbounds.HR_agg_min_group(:,3);
    HR_agg_max_g3 = DECbounds.HR_agg_max_group(:,3);
    HR_struc_min_g3 = DECbounds.HR_struc_multi_min_group(:,3);
    HR_struc_max_g3 = DECbounds.HR_struc_multi_max_group(:,3);
    HR_heter_min_g3 = DECbounds.HR_heter_multi_min_group(:,3);
    HR_heter_max_g3 = DECbounds.HR_heter_multi_max_group(:,3);
    
    HR_agg_min_g4 = DECbounds.HR_agg_min_group(:,4);
    HR_agg_max_g4 = DECbounds.HR_agg_max_group(:,4);
    HR_struc_min_g4 = DECbounds.HR_struc_multi_min_group(:,4);
    HR_struc_max_g4 = DECbounds.HR_struc_multi_max_group(:,4);
    HR_heter_min_g4 = DECbounds.HR_heter_multi_min_group(:,4);
    HR_heter_max_g4 = DECbounds.HR_heter_multi_max_group(:,4);
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    DECbounds.HR_agg_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;

    HR_agg_g1   = DECbounds.HR_agg_group(:,1);    
    HR_struc_g1 = DECbounds.HR_struc_multi_group(:,1);    
    HR_heter_g1 = DECbounds.HR_heter_multi_group(:,1);
    
    HR_agg_g2   = DECbounds.HR_agg_group(:,2);    
    HR_struc_g2 = DECbounds.HR_struc_multi_group(:,2);    
    HR_heter_g2 = DECbounds.HR_heter_multi_group(:,2);

    HR_agg_g3   = DECbounds.HR_agg_group(:,3);    
    HR_struc_g3 = DECbounds.HR_struc_multi_group(:,3);    
    HR_heter_g3 = DECbounds.HR_heter_multi_group(:,3);
    
    HR_agg_g4   = DECbounds.HR_agg_group(:,4);    
    HR_struc_g4 = DECbounds.HR_struc_multi_group(:,4);    
    HR_heter_g4 = DECbounds.HR_heter_multi_group(:,4);
    
    HR_between = (HR_between_min+HR_between_max)/2;
                
    tab = table(duration,...
        HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1,...
        HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_agg_min_g3, HR_agg_max_g3, ...
        HR_struc_min_g3, HR_struc_max_g3, HR_heter_min_g3,HR_heter_max_g3,...
        HR_agg_min_g4, HR_agg_max_g4, ...
        HR_struc_min_g4, HR_struc_max_g4, HR_heter_min_g4,HR_heter_max_g4,...
        HR_between_min,HR_between_max,...
        HR_agg_g1, HR_struc_g1, HR_heter_g1,...
        HR_agg_g2, HR_struc_g2, HR_heter_g2,...
        HR_agg_g3, HR_struc_g3, HR_heter_g3,...
        HR_agg_g4, HR_struc_g4, HR_heter_g4,...
        HR_between);
    writetable(tab,'HR_decomposition_obs_age_RP.txt','Delimiter',' ');       
end    

if (output_files_write ==1) && (OBS_NACE == 1)
    duration = DEC.tgrid(:);
    HR_agg_min_g1 = DECbounds.HR_agg_min_group(:,1);
    HR_agg_max_g1 = DECbounds.HR_agg_max_group(:,1);
    HR_struc_min_g1 = DECbounds.HR_struc_multi_min_group(:,1);
    HR_struc_max_g1 = DECbounds.HR_struc_multi_max_group(:,1);
    HR_heter_min_g1 = DECbounds.HR_heter_multi_min_group(:,1);
    HR_heter_max_g1 = DECbounds.HR_heter_multi_max_group(:,1);

    HR_agg_min_g2 = DECbounds.HR_agg_min_group(:,2);
    HR_agg_max_g2 = DECbounds.HR_agg_max_group(:,2);
    HR_struc_min_g2 = DECbounds.HR_struc_multi_min_group(:,2);
    HR_struc_max_g2 = DECbounds.HR_struc_multi_max_group(:,2);
    HR_heter_min_g2 = DECbounds.HR_heter_multi_min_group(:,2);
    HR_heter_max_g2 = DECbounds.HR_heter_multi_max_group(:,2);

    HR_agg_min_g3 = DECbounds.HR_agg_min_group(:,3);
    HR_agg_max_g3 = DECbounds.HR_agg_max_group(:,3);
    HR_struc_min_g3 = DECbounds.HR_struc_multi_min_group(:,3);
    HR_struc_max_g3 = DECbounds.HR_struc_multi_max_group(:,3);
    HR_heter_min_g3 = DECbounds.HR_heter_multi_min_group(:,3);
    HR_heter_max_g3 = DECbounds.HR_heter_multi_max_group(:,3);
    
    HR_agg_min_g4 = DECbounds.HR_agg_min_group(:,4);
    HR_agg_max_g4 = DECbounds.HR_agg_max_group(:,4);
    HR_struc_min_g4 = DECbounds.HR_struc_multi_min_group(:,4);
    HR_struc_max_g4 = DECbounds.HR_struc_multi_max_group(:,4);
    HR_heter_min_g4 = DECbounds.HR_heter_multi_min_group(:,4);
    HR_heter_max_g4 = DECbounds.HR_heter_multi_max_group(:,4);
    
    HR_agg_min_g5 = DECbounds.HR_agg_min_group(:,5);
    HR_agg_max_g5 = DECbounds.HR_agg_max_group(:,5);
    HR_struc_min_g5 = DECbounds.HR_struc_multi_min_group(:,5);
    HR_struc_max_g5 = DECbounds.HR_struc_multi_max_group(:,5);
    HR_heter_min_g5 = DECbounds.HR_heter_multi_min_group(:,5);
    HR_heter_max_g5 = DECbounds.HR_heter_multi_max_group(:,5);
    
    HR_agg_min_g6 = DECbounds.HR_agg_min_group(:,6);
    HR_agg_max_g6 = DECbounds.HR_agg_max_group(:,6);
    HR_struc_min_g6 = DECbounds.HR_struc_multi_min_group(:,6);
    HR_struc_max_g6 = DECbounds.HR_struc_multi_max_group(:,6);
    HR_heter_min_g6 = DECbounds.HR_heter_multi_min_group(:,6);
    HR_heter_max_g6 = DECbounds.HR_heter_multi_max_group(:,6);

    HR_agg_min_g7 = DECbounds.HR_agg_min_group(:,7);
    HR_agg_max_g7 = DECbounds.HR_agg_max_group(:,7);
    HR_struc_min_g7 = DECbounds.HR_struc_multi_min_group(:,7);
    HR_struc_max_g7 = DECbounds.HR_struc_multi_max_group(:,7);
    HR_heter_min_g7 = DECbounds.HR_heter_multi_min_group(:,7);
    HR_heter_max_g7 = DECbounds.HR_heter_multi_max_group(:,7);
    
    HR_agg_min_g8 = DECbounds.HR_agg_min_group(:,8);
    HR_agg_max_g8 = DECbounds.HR_agg_max_group(:,8);
    HR_struc_min_g8 = DECbounds.HR_struc_multi_min_group(:,8);
    HR_struc_max_g8 = DECbounds.HR_struc_multi_max_group(:,8);
    HR_heter_min_g8 = DECbounds.HR_heter_multi_min_group(:,8);
    HR_heter_max_g8 = DECbounds.HR_heter_multi_max_group(:,8);
    
    HR_agg_min_g9 = DECbounds.HR_agg_min_group(:,9);
    HR_agg_max_g9 = DECbounds.HR_agg_max_group(:,9);
    HR_struc_min_g9 = DECbounds.HR_struc_multi_min_group(:,9);
    HR_struc_max_g9 = DECbounds.HR_struc_multi_max_group(:,9);
    HR_heter_min_g9 = DECbounds.HR_heter_multi_min_group(:,9);
    HR_heter_max_g9 = DECbounds.HR_heter_multi_max_group(:,9);    
    
    HR_between_min = DECbounds.HR_B_multi_min(:);
    HR_between_max = DECbounds.HR_B_multi_max(:);
    
    DECbounds.HR_agg_group = (DECbounds.HR_agg_min_group + DECbounds.HR_agg_max_group)/2;
    DECbounds.HR_struc_multi_group = (DECbounds.HR_struc_multi_min_group + DECbounds.HR_struc_multi_max_group)/2;
    DECbounds.HR_heter_multi_group = (DECbounds.HR_heter_multi_min_group + DECbounds.HR_heter_multi_max_group)/2;

    HR_agg_g1   = DECbounds.HR_agg_group(:,1);    
    HR_struc_g1 = DECbounds.HR_struc_multi_group(:,1);    
    HR_heter_g1 = DECbounds.HR_heter_multi_group(:,1);
    
    HR_agg_g2   = DECbounds.HR_agg_group(:,2);    
    HR_struc_g2 = DECbounds.HR_struc_multi_group(:,2);    
    HR_heter_g2 = DECbounds.HR_heter_multi_group(:,2);

    HR_agg_g3   = DECbounds.HR_agg_group(:,3);    
    HR_struc_g3 = DECbounds.HR_struc_multi_group(:,3);    
    HR_heter_g3 = DECbounds.HR_heter_multi_group(:,3);
    
    HR_agg_g4   = DECbounds.HR_agg_group(:,4);    
    HR_struc_g4 = DECbounds.HR_struc_multi_group(:,4);    
    HR_heter_g4 = DECbounds.HR_heter_multi_group(:,4);
    
    HR_agg_g5   = DECbounds.HR_agg_group(:,5);    
    HR_struc_g5 = DECbounds.HR_struc_multi_group(:,5);    
    HR_heter_g5 = DECbounds.HR_heter_multi_group(:,5);
    
    HR_agg_g6   = DECbounds.HR_agg_group(:,6);    
    HR_struc_g6 = DECbounds.HR_struc_multi_group(:,6);    
    HR_heter_g6 = DECbounds.HR_heter_multi_group(:,6);
    
    HR_agg_g7   = DECbounds.HR_agg_group(:,7);    
    HR_struc_g7 = DECbounds.HR_struc_multi_group(:,7);    
    HR_heter_g7 = DECbounds.HR_heter_multi_group(:,7);
    
    HR_agg_g8   = DECbounds.HR_agg_group(:,8);    
    HR_struc_g8 = DECbounds.HR_struc_multi_group(:,8);    
    HR_heter_g8 = DECbounds.HR_heter_multi_group(:,8);
    
    HR_agg_g9   = DECbounds.HR_agg_group(:,9);    
    HR_struc_g9 = DECbounds.HR_struc_multi_group(:,9);    
    HR_heter_g9 = DECbounds.HR_heter_multi_group(:,9);
        
    HR_between = (HR_between_min+HR_between_max)/2;
                
    tab = table(duration,...
        HR_agg_min_g1,HR_agg_max_g1,HR_struc_min_g1,HR_struc_max_g1,...
        HR_heter_min_g1, HR_heter_max_g1,...
        HR_agg_min_g2, HR_agg_max_g2, ...
        HR_struc_min_g2, HR_struc_max_g2, HR_heter_min_g2,HR_heter_max_g2,...
        HR_agg_min_g3, HR_agg_max_g3, ...
        HR_struc_min_g3, HR_struc_max_g3, HR_heter_min_g3,HR_heter_max_g3,...
        HR_agg_min_g4, HR_agg_max_g4, ...
        HR_struc_min_g4, HR_struc_max_g4, HR_heter_min_g4,HR_heter_max_g4,...
        HR_agg_min_g5, HR_agg_max_g5, ...
        HR_struc_min_g5, HR_struc_max_g5, HR_heter_min_g5,HR_heter_max_g5,...
        HR_agg_min_g6, HR_agg_max_g6, ...
        HR_struc_min_g6, HR_struc_max_g6, HR_heter_min_g6,HR_heter_max_g6,...        
        HR_agg_min_g7, HR_agg_max_g7, ...
        HR_struc_min_g7, HR_struc_max_g7, HR_heter_min_g7,HR_heter_max_g7,...        
        HR_agg_min_g8, HR_agg_max_g8, ...
        HR_struc_min_g8, HR_struc_max_g8, HR_heter_min_g8,HR_heter_max_g8,...        
        HR_agg_min_g9, HR_agg_max_g9, ...
        HR_struc_min_g9, HR_struc_max_g9, HR_heter_min_g9,HR_heter_max_g9,...                
        HR_between_min,HR_between_max,...
        HR_agg_g1, HR_struc_g1, HR_heter_g1,...
        HR_agg_g2, HR_struc_g2, HR_heter_g2,...
        HR_agg_g3, HR_struc_g3, HR_heter_g3,...
        HR_agg_g4, HR_struc_g4, HR_heter_g4,...
        HR_agg_g5, HR_struc_g5, HR_heter_g5,...
        HR_agg_g6, HR_struc_g6, HR_heter_g6,...
        HR_agg_g7, HR_struc_g7, HR_heter_g7,...
        HR_agg_g8, HR_struc_g8, HR_heter_g8,...
        HR_agg_g9, HR_struc_g9, HR_heter_g9,...        
        HR_between);
    writetable(tab,'HR_decomposition_obs_industry_RP.txt','Delimiter',' ');       
end

end


%=========================================================================
% FIGURES

HETERtemp = [GBARdecomp.HR_heter_multi GUSHORTdecomp.HR_heter_multi ...
          GBARWdecomp.HR_heter_multi GUSHORTWdecomp.HR_heter_multi...
          GBARP2decomp.HR_heter_multi GUSHORTP2decomp.HR_heter_multi ...
          GBARP2Wdecomp.HR_heter_multi GUSHORTP2Wdecomp.HR_heter_multi]';      
HETERlower = min(HETERtemp)';          
HETERupper = max(HETERtemp)'; 
HETERmean = (HETERlower + HETERupper)/2;


duration = DEC.tgrid(:);

figure(6)
subplot(1,2,1); 
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_gnd.HR_heter_multi_mean_group(:,1),'k','LineWidth',1.5)
semilogy(duration,DECbounds_gnd.HR_heter_multi_mean_group(:,2),'b','LineWidth',1.5)
semilogy(duration,DECbounds_gnd.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_gnd.HR_heter_multi_min_group(:,1)' fliplr(DECbounds_gnd.HR_heter_multi_max_group(:,1)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_gnd.HR_heter_multi_min_group(:,2)' fliplr(DECbounds_gnd.HR_heter_multi_max_group(:,2)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_gnd.HR_B_multi_min' fliplr(DECbounds_gnd.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','women','men','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')

subplot(1,2,2)
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_rcl.HR_heter_multi_mean_group(:,1),'k','LineWidth',1.5)
semilogy(duration,DECbounds_rcl.HR_heter_multi_mean_group(:,2),'b','LineWidth',1.5)
semilogy(duration,DECbounds_rcl.HR_heter_multi_mean_group(:,3),'m','LineWidth',1.5)
semilogy(duration,DECbounds_rcl.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl.HR_heter_multi_min_group(:,1)' fliplr(DECbounds_rcl.HR_heter_multi_max_group(:,1)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl.HR_heter_multi_min_group(:,2)' fliplr(DECbounds_rcl.HR_heter_multi_max_group(:,2)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl.HR_heter_multi_min_group(:,3)' fliplr(DECbounds_rcl.HR_heter_multi_max_group(:,3)')],'m','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl.HR_B_multi_min'                fliplr(DECbounds_rcl.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','p<0.25','0.25<=p<0.75','p>=0.75','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')
sgtitle('Figure 6: Decomposition of hazard rate with observable characteristics.')

figure(11)
subplot(2,2,1);
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_educ.HR_heter_multi_mean_group(:,3),'k','LineWidth',1.5)
semilogy(duration,DECbounds_educ.HR_heter_multi_mean_group(:,4),'b','LineWidth',1.5)
semilogy(duration,DECbounds_educ.HR_heter_multi_mean_group(:,5),'m','LineWidth',1.5)
semilogy(duration,DECbounds_educ.HR_heter_multi_mean_group(:,6),'Color',[0.9290 0.6940 0.1250],'LineWidth',1.5)
semilogy(duration,DECbounds_educ.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_educ.HR_heter_multi_min_group(:,3)' fliplr(DECbounds_educ.HR_heter_multi_max_group(:,3)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_educ.HR_heter_multi_min_group(:,4)' fliplr(DECbounds_educ.HR_heter_multi_max_group(:,4)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_educ.HR_heter_multi_min_group(:,5)' fliplr(DECbounds_educ.HR_heter_multi_max_group(:,5)')],'m','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_educ.HR_heter_multi_min_group(:,6)' fliplr(DECbounds_educ.HR_heter_multi_max_group(:,6)')],'c','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_educ.HR_B_multi_min' fliplr(DECbounds_educ.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','middle','tech.sec.','acad.sec.','college','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')


subplot(2,2,2); 
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_age.HR_heter_multi_mean_group(:,1),'k','LineWidth',1.5)
semilogy(duration,DECbounds_age.HR_heter_multi_mean_group(:,2),'b','LineWidth',1.5)
semilogy(duration,DECbounds_age.HR_heter_multi_mean_group(:,3),'m','LineWidth',1.5)
semilogy(duration,DECbounds_age.HR_heter_multi_mean_group(:,4),'Color',[0.9290 0.6940 0.1250],'LineWidth',1.5)
semilogy(duration,DECbounds_age.HR_B_multi_mean,'g')
semilogy(duration,DECbounds_age.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_age.HR_heter_multi_min_group(:,1)' fliplr(DECbounds_age.HR_heter_multi_max_group(:,1)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_age.HR_heter_multi_min_group(:,2)' fliplr(DECbounds_age.HR_heter_multi_max_group(:,2)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_age.HR_heter_multi_min_group(:,3)' fliplr(DECbounds_age.HR_heter_multi_max_group(:,3)')],'m','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_age.HR_heter_multi_min_group(:,4)' fliplr(DECbounds_age.HR_heter_multi_max_group(:,4)')],'c','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_age.HR_B_multi_min'                fliplr(DECbounds_age.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','26--35','36--45','46--55','>55','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')

subplot(2,2,3); 
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_nace.HR_heter_multi_mean_group(:,5),'k','LineWidth',1.5)
semilogy(duration,DECbounds_nace.HR_heter_multi_mean_group(:,4),'b','LineWidth',1.5)
semilogy(duration,DECbounds_nace.HR_heter_multi_mean_group(:,2),'m','LineWidth',1.5)
semilogy(duration,DECbounds_nace.HR_heter_multi_mean_group(:,7),'Color',[0.9290 0.6940 0.1250],'LineWidth',1.5)
semilogy(duration,DECbounds_nace.HR_B_multi_mean,'g')
semilogy(duration,DECbounds_nace.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_nace.HR_heter_multi_min_group(:,5)' fliplr(DECbounds_nace.HR_heter_multi_max_group(:,5)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_nace.HR_heter_multi_min_group(:,4)' fliplr(DECbounds_nace.HR_heter_multi_max_group(:,4)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_nace.HR_heter_multi_min_group(:,2)' fliplr(DECbounds_nace.HR_heter_multi_max_group(:,2)')],'m','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_nace.HR_heter_multi_min_group(:,7)' fliplr(DECbounds_nace.HR_heter_multi_max_group(:,7)')],'c','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_nace.HR_B_multi_min'                fliplr(DECbounds_nace.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','retail','construction','manuf.','business serv.','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')

subplot(2,2,4)
semilogy(duration,HETERmean,'r','LineWidth',1.5)
hold on
semilogy(duration,DECbounds_rcl91.HR_heter_multi_mean_group(:,1),'k','LineWidth',1.5)
semilogy(duration,DECbounds_rcl91.HR_heter_multi_mean_group(:,2),'b','LineWidth',1.5)
semilogy(duration,DECbounds_rcl91.HR_heter_multi_mean_group(:,3),'m','LineWidth',1.5)
semilogy(duration,DECbounds_rcl91.HR_B_multi_mean,'g')
patch([duration' fliplr(duration')],[HETERlower' fliplr(HETERupper')],'r','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl91.HR_heter_multi_min_group(:,1)' fliplr(DECbounds_rcl91.HR_heter_multi_max_group(:,1)')],'k','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl91.HR_heter_multi_min_group(:,2)' fliplr(DECbounds_rcl91.HR_heter_multi_max_group(:,2)')],'b','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl91.HR_heter_multi_min_group(:,3)' fliplr(DECbounds_rcl91.HR_heter_multi_max_group(:,3)')],'m','LineStyle','none');
patch([duration' fliplr(duration')],[DECbounds_rcl91.HR_B_multi_min'                fliplr(DECbounds_rcl91.HR_B_multi_max')],'g','LineStyle','none');
alpha(.2)
legend('all','p<0.25','0.25<=p<0.75','p>=0.75','between')
xlim([0 104])
ylim([0.05 1])
xlabel('duration in weeks')
ylabel('heterogeneity effect')
sgtitle('Figure 11: Decomposition of hazard rate with observable characteristics.')


return

